/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.renderers;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.scoreboards.AssignedScoreboard;
import net.impactdev.impactor.api.scoreboards.ScoreboardRenderer;
import net.impactdev.impactor.api.scoreboards.lines.ScoreboardLine;
import net.impactdev.impactor.api.scoreboards.objectives.Objective;
import net.impactdev.impactor.minecraft.api.items.AdventureTranslator;
import net.impactdev.impactor.minecraft.api.items.ServerProvider;
import net.impactdev.impactor.minecraft.mixins.MixinBridge;
import net.impactdev.impactor.minecraft.platform.sources.ImpactorPlatformPlayer;
import net.impactdev.impactor.minecraft.scoreboard.assigned.ScoreboardComponents;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.pointer.Pointer;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_2736;
import net.minecraft.class_2751;
import net.minecraft.class_2757;
import net.minecraft.class_3244;
import net.minecraft.class_5900;
import net.minecraft.class_8646;

public class PacketBasedRenderer
implements ScoreboardRenderer {
    private static final Pointer<Integer> TEAM_INDEX = Pointer.pointer(Integer.class, (Key)Key.key((String)"impactor", (String)"team-index"));

    @Override
    public void objective(AssignedScoreboard scoreboard, Objective.Displayed objective) {
        class_2751 update = new class_2751(ScoreboardComponents.OBJECTIVE, 2);
        Impactor.instance().factories().provide(MixinBridge.class).setObjectiveTitle(update, objective.text());
        this.publish(scoreboard.viewer(), new class_2596[]{update});
    }

    @Override
    public void line(AssignedScoreboard scoreboard, ScoreboardLine.Displayed line) {
        class_268 team = ScoreboardComponents.team(line.require(TEAM_INDEX));
        this.applyLineTextToPacket(scoreboard, line, team, false);
    }

    private void applyLineTextToPacket(AssignedScoreboard scoreboard, ScoreboardLine.Displayed line, class_268 team, boolean create) {
        class_5900 update = class_5900.method_34172((class_268)team, (boolean)create);
        AdventureTranslator.Server translator = AdventureTranslator.Server.get(ServerProvider.server());
        class_2757 score = new class_2757(ScoreboardComponents.fakeName(line.require(TEAM_INDEX)), "\u00bbImpactor Objective\u00ab", line.score().value(), Optional.of(translator.asNative(line.text())), Optional.empty());
        this.publish(scoreboard.viewer(), new class_2596[]{update, score});
    }

    @Override
    public void show(AssignedScoreboard scoreboard) {
        class_2751 create = new class_2751(ScoreboardComponents.OBJECTIVE, 0);
        class_2736 display = new class_2736(class_8646.field_45157, ScoreboardComponents.OBJECTIVE);
        this.publish(scoreboard.viewer(), new class_2596[]{create, display});
        AtomicInteger index = new AtomicInteger();
        scoreboard.lines().forEach(line -> {
            line.with(TEAM_INDEX, index.getAndIncrement());
            this.createTeam(scoreboard, (ScoreboardLine.Displayed)line);
        });
    }

    @Override
    public void hide(AssignedScoreboard scoreboard) {
        ((ImpactorPlatformPlayer)scoreboard.viewer()).asMinecraftPlayer().ifPresent(player -> {
            class_2751 remove = new class_2751(ScoreboardComponents.OBJECTIVE, 1);
            player.field_13987.method_14364((class_2596)remove);
        });
    }

    @Override
    public void createTeam(AssignedScoreboard scoreboard, ScoreboardLine.Displayed line) {
        class_268 team = ScoreboardComponents.team(line.require(TEAM_INDEX));
        this.applyLineTextToPacket(scoreboard, line, team, true);
    }

    @Override
    public void destroyTeam(AssignedScoreboard scoreboard, ScoreboardLine.Displayed line) {
        class_268 team = ScoreboardComponents.team(line.require(TEAM_INDEX));
        class_5900 packet = class_5900.method_34170((class_268)team);
        this.publish(scoreboard.viewer(), new class_2596[]{packet});
    }

    private void publish(PlatformPlayer player, class_2596<?> ... packets) {
        ((ImpactorPlatformPlayer)player).asMinecraftPlayer().map(p -> p.field_13987).ifPresent(connection -> Arrays.stream(packets).forEach(arg_0 -> ((class_3244)connection).method_14364(arg_0)));
    }

    private <I, T extends I> T translate(I input, Class<T> target) {
        return target.cast(input);
    }
}

